define(["angular",
	"app",
	"moment"],
	function (angular,
			  app,
			  moment,
			  Highcharts) {
	"use strict";
	app.controller("GoalHistoryController", function (formatter,
													  $scope,
													  $state,
													  $stateParams,
													  focusService,
													  $window,
													  globalDelayTracker,
													  FitnessService,
													  TrackersConstants,
													  GraphService,
													  FitnessRemindersService,
													  FitnessGoalsFHIRService,
													  FitnessActivityFHIRService,
													  HomePageConstants,
													  FitnessConstants,
													  GoalHistoryGraphService,
													  $timeout,
													  TrackersService,
													  $parse) {

        var service = FitnessService.instance($state.current.data.sectionName);

		$scope.details = {};
		$scope.details.startDate = minDate;
		$scope.details.endDate = defaultMax;

		$scope.activitydetails = {};


		$scope.globalDelayTracker = globalDelayTracker;
		focusService.focusMain();
		$scope.today = new Date();
		$scope.sectionTitle = "Goal History";
		$scope.section = "fitness-goals";
		$scope.isPhoneView = $window.innerWidth < 768;	

        var minDate = moment().subtract(6, 'year').format('L'),
            defaultMin = moment().subtract(1, 'month').format('L'),
            defaultMax = moment().format('L'),
            defaultFilters = {
                startDate: defaultMin,
                endDate: defaultMax,
            };


		var trophyIconButton = {
				getLabel : function() {
					return "Set Weekly Activity Goals";
				},
				getPhoneLabel : function() {
					return "Set Goals";
				},
				getIcon : function() {
					return "icon-trophy";
				},
				onClick : function(isDropdownButton) {
					$scope.openGoalsModal(isDropdownButton);
				},
				getAriaLabel : function() {
					return "Trophy icon Weekly Activity Goals";
				},
				getPhoneAriaLabel : function() {
					return "Trophy icon Goals";
				}
			},

			notificationButton = {
				getLabel: function() {
					return 'Notifications (' + $scope.notificationDetails.notificationStatus + ')';
				},
				getIcon: function() {
					return 'icon-notification';
				},
				onClick: function() {
					$state.go('main.auth.fitness.notification', $stateParams);
				}
			};

        $scope.allowedDateRange = { min: minDate };

		$scope.filter = {
            service: service,
            defaults: defaultFilters,
            model: angular.copy(service.dataPointers.filters),

        };
		$scope.activityFilter = {
			service: FitnessActivityFHIRService,
			defaults: defaultFilters,
			model: angular.copy(service.dataPointers.filters)

		};
		$scope.goalFilter = {
			service: FitnessGoalsFHIRService,
			defaults: defaultFilters,
			model: angular.copy(service.dataPointers.filters),
			callbacks : {
				filter : function() {
					processData();
				}
			}

		};

		$scope.openGoalsModal = function (focusOptionsButton) {
			FitnessService.openGoalsModal($scope.details).then(function (details) {
				service.save(details).then(function () {
					setDetails(true);
					location.reload(true);
				})
			}).finally(function () {
				if (focusOptionsButton) {
					focusService.focusElement(angular.element('span.dropdown button.dropdown-toggle'));
				} else {
					focusService.focusElement(angular.element('button[title*="Goals"]'));
				}
			});
		};

		function setDetails(fetchNew) {
			if (goalService.dataPointers.list.length === 0) {
				$scope.details = goalService.createEmpty();
			} else {
				$scope.details = goalService.dataPointers.list[0];
				angular.extend($scope.details,HomePageConstants["weekly-goals"]);

				if (fetchNew) {
					goalService.fetch().then(function () {
						$scope.statusMsg = $scope.details.endDate ? getStatusMsg($scope.details) : '';
						setDetails();

					});
				}
			}

			$scope.goalGraphConfig = GoalGraphService.getGraphConfig($scope.details);
			$scope.screenReaderText = GoalGraphAccessibilityService.getScreenReaderTexts($scope.details);
		}


		angular.extend($scope.goalFilter, HomePageConstants["weekly-goals"]);
		angular.extend($scope.activityFilter, HomePageConstants["weekly-goals"]);


		var activityDetail = [];
		activityDetail.push($scope.activityFilter.extensions);

		var goalDetail =[];
		goalDetail.push($scope.goalFilter.extensions);

		var activitySummary = {};
		activitySummary = JSON.parse('{"progress" : {"minutes": "undefined" , "steps": "undefined" , "miles": "undefined"}}');
		var goalSummary = {};
		goalSummary = JSON.parse('{"startDate":"01/01/1900","target" : {"minutes": 0 , "steps": 0 , "miles": 0}}');

		var minutes = 0;
		var steps = 0;
		var miles = 0;



		$scope.xsScreenResolution = function () {return $window.innerWidth < 768;};

		var processDetails = [];

		angular.extend($scope.goalFilter.service.dataPointers.list,goalSummary);

		var goalDatevar = "";

		angular.forEach($scope.goalFilter.service.dataPointers.list, function (key, index) {

			angular.extend(key, goalSummary);
			key.target.minutes = key.component[0].valueQuantity.value;
			key.target.steps = parseInt(key.extension[1].valueString);
			key.target.miles = key.component[1].valueQuantity.value;
			key.startDate = key.extension[4].valueString;
			goalDatevar = key.startDate;

			processDetails.push(key);

		});

		if ($scope.activityFilter.service.dataPointers.list.length <= 0) {
			angular.extend($scope.activityFilter.service.dataPointers.list, activitySummary);
		}



		angular.forEach($scope.activityFilter.service.dataPointers.list, function (key, index) {
			angular.extend(key,activitySummary);
			key.progress.startDate = goalDatevar;

			minutes = minutes + key.component[0].valueQuantity.value;
			steps = steps + parseInt(key.extension[1].valueString);
			miles = miles + key.component[1].valueQuantity.value;

			processDetails.push(key);

		});

		$scope.activityFilter.progress.minutes=minutes;
		$scope.activityFilter.progress.steps=steps;
		$scope.activityFilter.progress.miles=miles;



		var addGoal = function() {
			if (!$scope.details) {
				$stateParams.id = null;
				$state.go($state.current.name, $stateParams, { reload: true });
			}
		};

        var processData = function() {

        	//we create a list from the returned records that we can use with the existing table & graph templates
			service.dataPointers['formattedList'] = [];
			//create a record for each goal+target

        	for (var i = 0;i<processDetails.length;i++) {
				Object.keys(processDetails[i].target).sort().forEach(function(typ, i) {

					var itm = {
						goalDate : processDetails[i].startDate,
						goalDateTime : processDetails[i].startDate,
						goalDateSortKey : processDetails[i].startDate,
						goal: processDetails[i].target[typ],
						achieved : 0,
						units : typ,
						met : 'No'
					}
					if (typeof processDetails[i]['progress'] != 'undefined' &&
						typeof processDetails[i].progress[typ] != 'undefined') {
						itm.achieved = processDetails[i].progress[typ];

						try {
							if (itm.achieved / itm.goal >= 1)
							{itm.met = 'Yes!';}
						} catch (e) {

						}						
					}
					itm["startDate"] = itm.goalDate;
					itm['summary'] = itm.achieved + '/' + itm.goal + ' ' + itm.units;
					service.dataPointers['formattedList'].push(itm);

				});
        	}

        	$scope.details = service.dataPointers.formattedList;

        	
        };

        service.fetch($stateParams.dateRange || $scope.goalFilter.defaults).then(function() {
        	processData();
        });


		var graphMetaData = TrackersConstants["fitness-goals-legacy"].entry.vitalObservationsMeta;

		// internal functions
		var makeGraph = function() {
			if (graphMetaData) {
				$scope.graphConfig = GraphService.getGraphConfig($scope.section, service.dataPointers.filters || $scope.filter.model || $scope.filter.defaults, service.dataPointers.list, graphMetaData, $scope.sectionTitle);
			}
		};

		service.fetch($stateParams.dateRange || $scope.filter.defaults).then(function() {



			makeGraph();
		});
        
        var tableGraphButton = {
            getLabel : function() {
                return $scope.isGraphView ? "Table" : "Graph";
            },
            getIcon : function() {
                return $scope.isGraphView ? "icon-list" : "icon-graph";
            },
            onClick : function(isDropdownButton) {
				if (isDropdownButton) {
					focusService.focusElement(angular.element('span.dropdown button.dropdown-toggle'));
				}
                $scope.isGraphView = !$scope.isGraphView;
                $scope.filter.noFocus = $scope.isGraphView;
            }
        };

		$scope.getDetails = function (item) {

			$stateParams.id = item ? service.idGetter ? service.idGetter(item) : item.id : null;
			$state.go(".entry", $stateParams);
			$stateParams.dateRange = $scope.filter.model;
		};

        $scope.navButtons = {
			rightNoOptions : [],
            right : [tableGraphButton,trophyIconButton, notificationButton]
        };

		$scope.notificationDetails = {
			notificationStatus: ''
		};

		FitnessRemindersService.init('fitness-goals');
		FitnessRemindersService.getReminder().then(function (response) {
			$scope.notificationDetails = angular.copy(response);
		});

		var onViewChange = function () {
            focusService.focusPrimary();
        };
        $scope.$on('$viewContentLoaded', onViewChange);
        $scope.$on('$stateChangeSuccess', onViewChange);

		angular.extend($scope, FitnessConstants[$state.current.data.sectionName].summary);

		if (!navigator.userAgent.match(/(iPad|iPhone|iPod)/g)) {
			angular.element($window).bind('resize.fitnessGraphResize', function () {
				$timeout(function () {
					angular.forEach(Highcharts.charts, function (chart) {
						if (chart) {
							chart.setSize(chart.chartWidth, chart.chartHeight, false);
						}
					});
				});
			});

			$scope.$on("$destroy", function () {
				$(window).off("resize.fitnessGraphResize");
			});
		}

	});
});